<?php defined('ALTUMCODE') || die() ?>

<div class="container">
    <?= \Altum\Alerts::output_alerts() ?>

    <nav aria-label="breadcrumb">
        <ol class="custom-breadcrumbs small">
            <li><a href="<?= url('tools') ?>"><?= l('tools.breadcrumb') ?></a> <i class="fa fa-fw fa-angle-right"></i></li>
            <li class="active" aria-current="page"><?= l('tools.case_converter.name') ?></li>
        </ol>
    </nav>

    <div class="row mb-4">
        <div class="col-12 col-xl d-flex align-items-center mb-3 mb-xl-0">
            <h1 class="h4 m-0"><?= l('tools.case_converter.name') ?></h1>

            <div class="ml-2">
                <span data-toggle="tooltip" title="<?= l('tools.case_converter.description') ?>">
                    <i class="fa fa-fw fa-info-circle text-muted"></i>
                </span>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body">

            <form action="" method="post" role="form">
                <input type="hidden" name="token" value="<?= \Altum\Middlewares\Csrf::get() ?>" />

                <div class="form-group">
                    <label for="text"><i class="fa fa-fw fa-paragraph fa-sm text-muted mr-1"></i> <?= l('tools.case_converter.text') ?></label>
                    <textarea id="text" name="text" class="form-control <?= \Altum\Alerts::has_field_errors('text') ? 'is-invalid' : null ?>" required="required"><?= $data->values['text'] ?></textarea>
                    <?= \Altum\Alerts::output_field_error('text') ?>
                </div>

                <div class="form-group">
                    <label for="type"><i class="fa fa-fw fa-sm fa-fingerprint text-muted mr-1"></i> <?= l('tools.case_converter.type') ?></label>
                    <select id="type" name="type" class="form-control" required="required">
                        <option value="lowercase" <?= $data->values['type'] == 'lowercase' ? 'selected="selected"' : null ?>><?= l('tools.case_converter.lowercase') ?></option>
                        <option value="uppercase" <?= $data->values['type'] == 'uppercase' ? 'selected="selected"' : null ?>><?= l('tools.case_converter.uppercase') ?></option>
                        <option value="sentencecase" <?= $data->values['type'] == 'sentencecase' ? 'selected="selected"' : null ?>><?= l('tools.case_converter.sentencecase') ?></option>
                        <option value="camelcase" <?= $data->values['type'] == 'camelcase' ? 'selected="selected"' : null ?>><?= l('tools.case_converter.camelcase') ?></option>
                        <option value="pascalcase" <?= $data->values['type'] == 'pascalcase' ? 'selected="selected"' : null ?>><?= l('tools.case_converter.pascalcase') ?></option>
                        <option value="capitalcase" <?= $data->values['type'] == 'capitalcase' ? 'selected="selected"' : null ?>><?= l('tools.case_converter.capitalcase') ?></option>
                        <option value="constantcase" <?= $data->values['type'] == 'constantcase' ? 'selected="selected"' : null ?>><?= l('tools.case_converter.constantcase') ?></option>
                        <option value="dotcase" <?= $data->values['type'] == 'dotcase' ? 'selected="selected"' : null ?>><?= l('tools.case_converter.dotcase') ?></option>
                        <option value="snakecase" <?= $data->values['type'] == 'snakecase' ? 'selected="selected"' : null ?>><?= l('tools.case_converter.snakecase') ?></option>
                        <option value="paramcase" <?= $data->values['type'] == 'paramcase' ? 'selected="selected"' : null ?>><?= l('tools.case_converter.paramcase') ?></option>
                    </select>
                </div>

                <button type="submit" name="submit" class="btn btn-block btn-primary"><?= l('global.submit') ?></button>
            </form>

        </div>
    </div>

    <?php if(isset($data->result)): ?>
        <div class="mt-4">

            <div class="card">
                <div class="card-body">

                    <div class="form-group">
                        <div class="d-flex justify-content-between align-items-center">
                            <label for="result"><?= l('tools.case_converter.text') ?></label>
                            <div>
                                <button
                                        type="button"
                                        class="btn btn-link text-muted"
                                        data-toggle="tooltip"
                                        title="<?= l('global.clipboard_copy') ?>"
                                        aria-label="<?= l('global.clipboard_copy') ?>"
                                        data-copy="<?= l('global.clipboard_copy') ?>"
                                        data-copied="<?= l('global.clipboard_copied') ?>"
                                        data-clipboard-target="#result"
                                        data-clipboard-text
                                >
                                    <i class="fa fa-fw fa-sm fa-copy"></i>
                                </button>
                            </div>
                        </div>
                        <textarea id="result" class="form-control"><?= $data->result ?></textarea>
                    </div>

                </div>
            </div>

        </div>
    <?php endif ?>

    <div class="mt-4">
        <div class="card">
            <div class="card-body">
                <?= l('tools.case_converter.extra_content') ?>
            </div>
        </div>
    </div>
</div>

<?php include_view(THEME_PATH . 'views/partials/clipboard_js.php') ?>
