<?php defined('ALTUMCODE') || die() ?>

<div class="container">
    <?= \Altum\Alerts::output_alerts() ?>

    <div class="d-print-none">
        <nav aria-label="breadcrumb">
            <ol class="custom-breadcrumbs small">
                <li>
                    <a href="<?= url('payment-processors') ?>"><?= l('payment_processors.breadcrumb') ?></a><i class="fa fa-fw fa-angle-right"></i>
                </li>
                <li class="active" aria-current="page"><?= l('payment_processor_update.breadcrumb') ?></li>
            </ol>
        </nav>

        <div class="d-flex align-items-center mb-4">
            <h1 class="h4 text-truncate mb-0 mr-2"><?= l('payment_processor_update.header') ?></h1>

            <?= include_view(THEME_PATH . 'views/payment-processors/payment_processor_dropdown_button.php', ['id' => $data->payment_processor->payment_processor_id]) ?>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="" method="post" role="form">
                <input type="hidden" name="token" value="<?= \Altum\Middlewares\Csrf::get() ?>" />

                <div class="form-group">
                    <label for="name"><i class="fa fa-fw fa-signature fa-sm text-muted mr-1"></i> <?= l('payment_processors.input.name') ?></label>
                    <input type="text" id="name" name="name" class="form-control <?= \Altum\Alerts::has_field_errors('name') ? 'is-invalid' : null ?>" value="<?= $data->payment_processor->name ?>" required="required" />
                    <?= \Altum\Alerts::output_field_error('name') ?>
                </div>

                <div class="form-group">
                    <label for="processor"><i class="fa fa-fw fa-credit-card fa-sm text-muted mr-1"></i> <?= l('payment_processors.input.processor') ?></label>
                    <select id="processor" name="processor" class="form-control <?= \Altum\Alerts::has_field_errors('processor') ? 'is-invalid' : null ?>">
                        <?php foreach(['paypal', 'stripe'] as $processor): ?>
                            <option value="<?= $processor ?>" <?= $data->payment_processor->processor == $processor ? 'selected="selected"' : null ?>><?= l('pay.custom_plan.' . $processor) ?></option>
                        <?php endforeach ?>
                    </select>
                    <?= \Altum\Alerts::output_field_error('processor') ?>
                </div>

                <div>
                    <div class="form-group" data-processor="paypal">
                        <label for="mode"><?= l('payment_processors.input.paypal.mode') ?></label>
                        <select id="mode" name="mode" class="form-control">
                            <option value="live" <?= ($data->payment_processor->settings->mode ?? null) == 'live' ? 'selected="selected"' : null ?>><?= l('payment_processors.input.paypal.mode_live') ?></option>
                            <option value="sandbox" <?= ($data->payment_processor->settings->mode ?? null) == 'sandbox' ? 'selected="selected"' : null ?>><?= l('payment_processors.input.paypal.mode_sandbox') ?></option>
                        </select>
                    </div>

                    <div class="form-group" data-processor="paypal">
                        <label for="client_id"><?= l('payment_processors.input.paypal.client_id') ?></label>
                        <input id="client_id" type="text" name="client_id" class="form-control" value="<?= $data->payment_processor->settings->client_id ?? null ?>" required="required" />
                    </div>

                    <div class="form-group" data-processor="paypal">
                        <label for="secret"><?= l('payment_processors.input.paypal.secret') ?></label>
                        <input id="secret" type="text" name="secret" class="form-control" value="<?= $data->payment_processor->settings->secret ?? null ?>" required="required" />
                    </div>

                    <div data-processor="paypal">
                        <button class="btn btn-block btn-gray-200 my-4" type="button" data-toggle="collapse" data-target="#paypal_instructions_container" aria-expanded="false" aria-controls="paypal_instructions_container">
                            <i class="fa fa-fw fa-question-circle fa-sm mr-1"></i> <?= l('payment_processors.input.instructions') ?>
                        </button>

                        <div class="collapse" id="paypal_instructions_container">
                            <ol>
                                <li><?= l('payment_processors.input.paypal.instructions_1') ?></li>
                                <li><?= l('payment_processors.input.paypal.instructions_2') ?></li>
                                <li><?= l('payment_processors.input.paypal.instructions_3') ?></li>
                                <li><?= l('payment_processors.input.paypal.instructions_4') ?></li>
                                <li><?= l('payment_processors.input.paypal.instructions_5') ?></li>
                                <li><?= l('payment_processors.input.paypal.instructions_6') ?></li>
                                <li><?= sprintf(l('payment_processors.input.paypal.instructions_7'), SITE_URL . 'l/guest-payment-webhook?processor=paypal&payment_processor_id=' . $data->payment_processor->payment_processor_id) ?></li>
                                <li><?= l('payment_processors.input.paypal.instructions_8') ?></li>
                            </ol>
                        </div>
                    </div>
                </div>

                <div>
                    <div class="form-group" data-processor="stripe">
                        <label for="publishable_key"><?= l('payment_processors.input.stripe.publishable_key') ?></label>
                        <input id="publishable_key" type="text" name="publishable_key" class="form-control" value="<?= $data->payment_processor->settings->publishable_key ?? null ?>" required="required" />
                    </div>

                    <div class="form-group" data-processor="stripe">
                        <label for="secret_key"><?= l('payment_processors.input.stripe.secret_key') ?></label>
                        <input id="secret_key" type="text" name="secret_key" class="form-control" value="<?= $data->payment_processor->settings->secret_key ?? null ?>" required="required" />
                    </div>

                    <div class="form-group" data-processor="stripe">
                        <label for="webhook_secret"><?= l('payment_processors.input.stripe.webhook_secret') ?></label>
                        <input id="webhook_secret" type="text" name="webhook_secret" class="form-control" value="<?= $data->payment_processor->settings->webhook_secret ?? null ?>" required="required" />
                    </div>

                    <div data-processor="stripe">
                        <button class="btn btn-block btn-gray-200 my-4" type="button" data-toggle="collapse" data-target="#stripe_instructions_container" aria-expanded="false" aria-controls="stripe_instructions_container">
                            <i class="fa fa-fw fa-question-circle fa-sm mr-1"></i> <?= l('payment_processors.input.instructions') ?>
                        </button>

                        <div class="collapse" id="stripe_instructions_container">
                            <ol>
                                <li><?= l('payment_processors.input.stripe.instructions_1') ?></li>
                                <li><?= l('payment_processors.input.stripe.instructions_2') ?></li>
                                <li><?= l('payment_processors.input.stripe.instructions_3') ?></li>
                                <li><?= l('payment_processors.input.stripe.instructions_4') ?></li>
                                <li><?= l('payment_processors.input.stripe.instructions_5') ?></li>
                                <li><?= l('payment_processors.input.stripe.instructions_6') ?></li>
                                <li><?= sprintf(l('payment_processors.input.stripe.instructions_7'), SITE_URL . 'l/guest-payment-webhook?processor=stripe&payment_processor_id=' . $data->payment_processor->payment_processor_id) ?></li>
                                <li><?= l('payment_processors.input.stripe.instructions_8') ?></li>
                                <li><?= l('payment_processors.input.stripe.instructions_9') ?></li>
                            </ol>
                        </div>
                    </div>
                </div>

                <button type="submit" name="submit" class="btn btn-block btn-primary mt-3"><?= l('global.update') ?></button>
            </form>
        </div>
    </div>
</div>

<?php ob_start() ?>
<script>
    'use strict';

    /* Type handler */
    let type_handler = (selector, data_key) => {
        if(!document.querySelector(selector)) {
            return;
        }

        let type = document.querySelector(selector).value;

        document.querySelectorAll(`[${data_key}]:not([${data_key}="${type}"])`).forEach(element => {
            element.classList.add('d-none');
            let input = element.querySelector('input,select,textarea');

            if(input) {
                if(input.getAttribute('required')) {
                    input.setAttribute('data-is-required', 'true');
                }
                input.setAttribute('disabled', 'disabled');
                input.removeAttribute('required');
            }
        });

        document.querySelectorAll(`[${data_key}="${type}"]`).forEach(element => {
            element.classList.remove('d-none');
            let input = element.querySelector('input,select,textarea');

            if(input) {
                input.removeAttribute('disabled');
                if(input.getAttribute('data-is-required')) {
                    input.setAttribute('required', 'required')
                }
            }
        });
    }

    type_handler('select[name="processor"]', 'data-processor');
    document.querySelector('select[name="processor"]') && document.querySelector('select[name="processor"]').addEventListener('change', () => { type_handler('select[name="processor"]', 'data-processor'); });
</script>
<?php \Altum\Event::add_content(ob_get_clean(), 'javascript') ?>


<?php \Altum\Event::add_content(include_view(THEME_PATH . 'views/payment-processors/payment_processor_delete_modal.php'), 'modals'); ?>
